#!/system/bin/sh
#
#

export PATH=$PATH:/system/bin


ODM_DEF_PROP=/mnt/odm/default.prop
NOGAPPS=/mnt/odm/nogapps
GAPPS_LIST=/tmp/install/installed_gapps.txt

remove_single_file() {
  if test -f "$1"; then
        echo "removing preinstalled $1"
        rm $1
  fi
}

remove_gapps(){
  if test -f "$GAPPS_LIST"; then
    echo "found installed_gapps.txt"
    while read line; do
      if [ ! -z "$line" ]; then
        remove_single_file "/mnt/system/$line"
      fi
    done < $GAPPS_LIST
  fi
}

if test -f "$ODM_DEF_PROP"; then
    echo "deleting not used $ODM_DEF_PROP"
    rm $ODM_DEF_PROP
fi

if test -f "$NOGAPPS"; then
    echo "found /odm/nogapps, removing gapps!!!"
    remove_gapps
fi


HARDWARE=`cat /proc/cpuinfo | grep Hardware`
N2PLUS="N2Plus"
N2L="N2L"

if [ -z "${HARDWARE##*$N2PLUS*}" ] || [ -z "${HARDWARE##*$N2L*}" ]
then
    sed -i s/_big=\"1800\"/_big=\"2208\"/g /mnt/odm/env.ini;
    sed -i s/_little=\"1896\"/_little=\"1908\"/g /mnt/odm/env.ini;
fi
